<?php
    $gridDirection = $getGridDirection() ?? 'column';
    $id = $getId();
    $isDisabled = $isDisabled();
    $isInline = $isInline();
    $isMultiple = $isMultiple();
    $statePath = $getStatePath();
    $label = $getLabel();
    $previousRound = \App\Models\Round::where([
        'inscription_id' => $filterRoundPrevious['inscription'],
        'participant_id' => $filterRoundPrevious['participant'],
        'event_id' => $filterRoundPrevious['event'],
        'modality_id' => $filterRoundPrevious['modality'],
        'number' => $indexRound,
        'group' => $filterRoundPrevious['group'],
    ])->first();
?>

<div class="<?php if($firstLabel !== 0): ?> -mt-6 <?php endif; ?> min-w-fit flex justify-center">
    <table class="w-fit border-collapse">
        <!--[if BLOCK]><![endif]--><?php if($firstLabel != 0): ?>
            <thead>
                <tr>
                    <th
                        class="border border-1 border-gray-210 dark:border-white/10 p-4 text-center font-medium text-wrap break-words">
                        Inscrição</th>
                    <th
                        class="border border-1 border-gray-210 dark:border-white/10 p-4 text-center font-medium text-wrap break-words">
                        Participantes</th>
                    <!--[if BLOCK]><![endif]--><?php if($indexRound != 0): ?>
                        <th
                            class="border border-1 border-gray-210 dark:border-white/10 p-4 text-center font-medium text-wrap break-words">
                            Volta <?php echo e($indexRound); ?></th>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    <th
                        class="border border-1 border-gray-210 dark:border-white/10 p-4 text-center font-medium text-wrap break-words">
                        Volta <?php echo e($indexRound + 1); ?></th>
                </tr>
            </thead>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        <tbody>
            <tr>
                <td class="border border-1 border-gray-210 dark:border-white/10 p-4 text-center font-medium text-wrap break-words"
                    style="width: 11rem; max-width: 11rem;">
                    #<?php echo e($filterRoundPrevious['number']); ?>

                </td>
                <td class="border border-1 border-gray-210 dark:border-white/10 p-4 text-center font-medium text-wrap break-words"
                    style="width: 11rem; max-width: 11rem;">
                    <?php echo e(explode('|', $getLabel())[1]); ?>

                    <!--[if BLOCK]><![endif]--><?php if(explode('|', $getLabel())[0]): ?>
                        <br>
                        <span class="text-gray-500">Grupo: <?php echo e(explode('|', $getLabel())[0]); ?></span>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </td>
                <!--[if BLOCK]><![endif]--><?php if($indexRound != 0): ?>
                    <td class="border border-1 border-gray-210 dark:border-white/10 p-4 text-center font-medium text-wrap break-words"
                        style="width: 11rem; max-width: 11rem;">
                        <!--[if BLOCK]><![endif]--><?php if(!$previousRound || ($previousRound && is_null($previousRound->value))): ?>
                            -
                        <?php elseif($previousRound && $previousRound->value == 1): ?>
                            <span style="color: #4caf50; display: inline-block;">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                    stroke-width="4" stroke="currentColor" width="24" height="24" class="size-6">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="m4.5 12.75 6 6 9-13.5" />
                                </svg>
                            </span>
                        <?php else: ?>
                            <span style="color: red; display: inline-block;">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                    stroke-width="4" stroke="currentColor" width="24" height="24" lass="size-6">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M6 18 18 6M6 6l12 12" />
                                </svg>
                            </span>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </td>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                <td class="border border-1 border-gray-210 dark:border-white/10 p-4 w-fit">
                    <div class="flex justify-center items-center gap-3">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $getOptions(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $inputId = "{$id}-{$value}";
                                $shouldOptionBeDisabled = $isDisabled || $isOptionDisabled($value, $label);
                            ?>

                            <div class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                'break-inside-avoid' => !$isInline && $gridDirection === 'column',
                            ]); ?>">
                                <input <?php if($shouldOptionBeDisabled): echo 'disabled'; endif; ?> id="<?php echo e($inputId); ?>"
                                    <?php if(!$isMultiple): ?> name="<?php echo e($id); ?>" <?php endif; ?>
                                    type="<?php echo e($isMultiple ? 'checkbox' : 'radio'); ?>" value="<?php echo e($value); ?>"
                                    wire:loading.attr="disabled"
                                    <?php echo e($applyStateBindingModifiers('wire:model')); ?>="<?php echo e($statePath); ?>"
                                    <?php echo e($getExtraInputAttributeBag()->class(['peer pointer-events-none absolute opacity-0'])); ?> />

                                <?php if (isset($component)) { $__componentOriginal6330f08526bbb3ce2a0da37da512a11f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6330f08526bbb3ce2a0da37da512a11f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'filament::components.button.index','data' => ['color' => $getColor($value),'disabled' => $shouldOptionBeDisabled,'for' => $inputId,'icon' => $getIcon($value),'tag' => 'label','xOn:click' => '$nextTick(() => { $wire.set(\''.e($statePath).'\', \''.e($value).'\') })']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('filament::button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['color' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($getColor($value)),'disabled' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($shouldOptionBeDisabled),'for' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($inputId),'icon' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($getIcon($value)),'tag' => 'label','x-on:click' => '$nextTick(() => { $wire.set(\''.e($statePath).'\', \''.e($value).'\') })']); ?>
                                    <?php echo e($label); ?>

                                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6330f08526bbb3ce2a0da37da512a11f)): ?>
<?php $attributes = $__attributesOriginal6330f08526bbb3ce2a0da37da512a11f; ?>
<?php unset($__attributesOriginal6330f08526bbb3ce2a0da37da512a11f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6330f08526bbb3ce2a0da37da512a11f)): ?>
<?php $component = $__componentOriginal6330f08526bbb3ce2a0da37da512a11f; ?>
<?php unset($__componentOriginal6330f08526bbb3ce2a0da37da512a11f); ?>
<?php endif; ?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </td>
            </tr>
        </tbody>
    </table>
</div>
<?php /**PATH C:\Users\Ramos\Herd\freelas\laco_pro\resources\views/forms/components/toggle-wizard.blade.php ENDPATH**/ ?>