<!DOCTYPE html>
<html lang="pt-BR">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Tabela com Ícones Clicáveis</title>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">

</head>
<style>
    /* Estilos da tabela */
    table {
      width: 100%;
      border-collapse: collapse;
      background-color: #2c2c2c;
      color: #fff;
      font-family: Arial, sans-serif;
    }

    th,
    td {
      padding: 15px;
      text-align: center;
      border: 1px solid #444;
    }

     /*Esconde os inputs de rádio*/
    input[type="radio"] {
      display: none;
    }

    /* Estilo básico dos ícones */
    .thumbs-icon {
      font-size: 30px;
      color: #bbb;
      cursor: pointer;
      transition: color 0.3s, transform 0.2s;
      margin: 0 10px;
    }


    .thumbs-icon.is-checked {
      color: #4caf50; /* Verde para acerto */
      transform: scale(1.2);
    }

    .thumbs-icon.is-error {
        color: #f44336; /* Vermelho para erro */
    }

    /* Centralizar o conteúdo da página */
    body {
      justify-content: center;
      align-items: center;
      height: 100vh;
      background-color: #1e1e1e;
    }

    .percent-green {
        background-color: #4caf50; /* Verde */
        color: #fff;
    }

    .percent-red {
        background-color: #f44336; /* Vermelho */
        color: #fff;
    }
    /* Adicionando um pouco de estilo para os selects e ícones */
    .form-select {
        @apply border border-gray-300 rounded-md px-3 py-2;
    }
    .thumbs-icon {
        cursor: pointer;
        margin-right: 0.5rem;
    }
    .thumbs-icon.is-checked {
        color: green;
    }
    .thumbs-icon.is-error {
        color: red;
    }

</style>
<body>
  <div>
    <livewire:round-table />
  </div>
</body>

</html>
