@extends('layouts.app')

@section('content')
<div class="container mx-auto py-8">
    <div class="max-w-3xl mx-auto bg-white rounded-lg shadow-md p-6">
        <h1 class="text-2xl font-bold mb-6">Status do Pagamento</h1>
        
        @if(isset($error))
            <div class="bg-red-100 text-red-700 p-4 rounded mb-4">
                <p class="font-semibold">Erro ao verificar pagamento</p>
                <p>{{ $error }}</p>
            </div>
        @else
            <div class="mb-6">
                <h2 class="text-xl font-semibold mb-2">Detalhes do Pagamento</h2>
                <div class="bg-gray-100 p-4 rounded">
                    <p><strong>ID do Pagamento:</strong> {{ $payment->payment_id }}</p>
                    <p><strong>Método:</strong> 
                        @if($payment->payment_method == 'pix')
                            PIX
                        @elseif($payment->payment_method == 'credit_card')
                            Cartão de Crédito
                        @else
                            {{ $payment->payment_method }}
                        @endif
                    </p>
                    <p><strong>Valor:</strong> R$ {{ number_format($payment->amount, 2, ',', '.') }}</p>
                    <p><strong>Status:</strong> 
                        @if($payment->status == 'approved')
                            <span class="text-green-600 font-semibold">Aprovado</span>
                        @elseif($payment->status == 'pending')
                            <span class="text-yellow-600 font-semibold">Pendente</span>
                        @elseif($payment->status == 'rejected')
                            <span class="text-red-600 font-semibold">Rejeitado</span>
                        @else
                            <span class="font-semibold">{{ $payment->status }}</span>
                        @endif
                    </p>
                    @if($payment->paid_at)
                        <p><strong>Data de Pagamento:</strong> {{ $payment->paid_at->format('d/m/Y H:i:s') }}</p>
                    @endif
                </div>
            </div>

            @if($payment->status == 'approved')
                <div class="bg-green-100 text-green-700 p-4 rounded mb-4">
                    <p class="font-semibold">Pagamento aprovado!</p>
                    <p>Seu pagamento foi processado com sucesso e sua inscrição está confirmada.</p>
                </div>
                <div class="flex justify-center">
                    <a href="{{ route('payment.checkout', $payment->inscription_id) }}" class="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">Voltar para Inscrições</a>
                </div>
            @elseif($payment->status == 'pending')
                <div class="bg-yellow-100 text-yellow-700 p-4 rounded mb-4">
                    <p class="font-semibold">Pagamento pendente</p>
                    <p>Seu pagamento está sendo processado. Atualize esta página para verificar o status atualizado.</p>
                </div>
                @if($payment->payment_method == 'pix')
                    <div class="text-center mb-4">
                        <p class="mb-2">Se você ainda não realizou o pagamento, escaneie o QR Code abaixo:</p>
                        @if(isset($payment->payment_data['point_of_interaction']['transaction_data']['qr_code_base64']))
                            <div class="flex justify-center mb-4">
                                <img src="data:image/png;base64,{{ $payment->payment_data['point_of_interaction']['transaction_data']['qr_code_base64'] }}" alt="QR Code PIX" class="w-48 h-48">
                            </div>
                        @endif
                    </div>
                @endif
                <div class="flex justify-center space-x-4">
                    <button onclick="window.location.reload()" class="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">Atualizar Status</button>
                    <a href="{{ route('payment.checkout', $payment->inscription_id) }}" class="px-4 py-2 bg-gray-500 text-white rounded hover:bg-gray-600">Voltar</a>
                </div>
            @elseif($payment->status == 'rejected')
                <div class="bg-red-100 text-red-700 p-4 rounded mb-4">
                    <p class="font-semibold">Pagamento rejeitado</p>
                    <p>Seu pagamento foi rejeitado. Por favor, tente novamente com outro método de pagamento.</p>
                </div>
                <div class="flex justify-center">
                    <a href="{{ route('payment.checkout', $payment->inscription_id) }}" class="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">Tentar Novamente</a>
                </div>
            @endif
        @endif
    </div>
</div>
@endsection