@extends('layouts.app')

@section('content')
<div class="container mx-auto py-8">
    <div class="max-w-3xl mx-auto bg-white rounded-lg shadow-md p-6">
        <h1 class="text-2xl font-bold mb-6">Pagamento da Inscrição</h1>
        
        <div class="mb-6">
            <h2 class="text-xl font-semibold mb-2">Detalhes da Inscrição</h2>
            <div class="bg-gray-100 p-4 rounded">
                <p><strong>Modalidade:</strong> {{ $inscription->modality->name }}</p>
                <p><strong>Evento:</strong> {{ $inscription->modality->event->name }}</p>
                <p><strong>Valor:</strong> R$ {{ number_format($inscription->modality->price, 2, ',', '.') }}</p>
            </div>
        </div>

        <div class="mb-6">
            <h2 class="text-xl font-semibold mb-4">Escolha a forma de pagamento</h2>
            
            <div class="flex space-x-4 mb-6">
                <button id="pix-tab" class="px-4 py-2 bg-blue-500 text-white rounded active">PIX</button>
                <button id="credit-card-tab" class="px-4 py-2 bg-gray-300 text-gray-700 rounded">Cartão de Crédito</button>
            </div>
            
            <div id="pix-form" class="payment-form">
                <form id="form-pix" class="space-y-4">
                    @csrf
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="payer_email" class="block text-sm font-medium text-gray-700">Email</label>
                            <input type="email" id="payer_email" name="payer_email" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                        </div>
                        <div>
                            <label for="payer_document" class="block text-sm font-medium text-gray-700">CPF (apenas números)</label>
                            <input type="text" id="payer_document" name="payer_document" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                        </div>
                        <div>
                            <label for="payer_first_name" class="block text-sm font-medium text-gray-700">Nome</label>
                            <input type="text" id="payer_first_name" name="payer_first_name" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                        </div>
                        <div>
                            <label for="payer_last_name" class="block text-sm font-medium text-gray-700">Sobrenome</label>
                            <input type="text" id="payer_last_name" name="payer_last_name" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                        </div>
                    </div>
                    
                    <div class="flex justify-end">
                        <button type="submit" class="px-4 py-2 bg-green-500 text-white rounded hover:bg-green-600">Gerar PIX</button>
                    </div>
                </form>
                
                <div id="pix-result" class="mt-6 hidden">
                    <div class="text-center">
                        <h3 class="text-lg font-semibold mb-2">QR Code PIX</h3>
                        <p class="mb-4">Escaneie o QR Code abaixo com o aplicativo do seu banco</p>
                        <div class="flex justify-center mb-4">
                            <img id="pix-qrcode" src="" alt="QR Code PIX" class="w-48 h-48">
                        </div>
                        <div class="mb-4">
                            <p class="text-sm text-gray-600 mb-1">Ou copie o código PIX abaixo:</p>
                            <div class="flex items-center justify-center">
                                <input id="pix-code" type="text" readonly class="px-3 py-2 border rounded-l w-full max-w-md">
                                <button id="copy-pix" class="bg-blue-500 text-white px-3 py-2 rounded-r">Copiar</button>
                            </div>
                        </div>
                        <p class="text-sm text-gray-600">O pagamento será confirmado automaticamente após a transferência.</p>
                    </div>
                </div>
            </div>
            
            <div id="credit-card-form" class="payment-form hidden">
                <form id="form-credit-card" class="space-y-4">
                    @csrf
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div class="col-span-2">
                            <label for="card-number" class="block text-sm font-medium text-gray-700">Número do Cartão</label>
                            <div id="card-number" class="mt-1 block w-full h-10 rounded-md border-gray-300 shadow-sm bg-white px-3 py-2"></div>
                        </div>
                        <div>
                            <label for="card-expiry" class="block text-sm font-medium text-gray-700">Data de Validade</label>
                            <div id="card-expiry" class="mt-1 block w-full h-10 rounded-md border-gray-300 shadow-sm bg-white px-3 py-2"></div>
                        </div>
                        <div>
                            <label for="card-cvc" class="block text-sm font-medium text-gray-700">Código de Segurança</label>
                            <div id="card-cvc" class="mt-1 block w-full h-10 rounded-md border-gray-300 shadow-sm bg-white px-3 py-2"></div>
                        </div>
                        <div>
                            <label for="card-holder" class="block text-sm font-medium text-gray-700">Nome no Cartão</label>
                            <input type="text" id="card-holder" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                        </div>
                        <div>
                            <label for="installments" class="block text-sm font-medium text-gray-700">Parcelas</label>
                            <select id="installments" name="installments" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                                <option value="1">1x de R$ {{ number_format($inscription->modality->price, 2, ',', '.') }}</option>
                            </select>
                        </div>
                        <div>
                            <label for="cc_payer_email" class="block text-sm font-medium text-gray-700">Email</label>
                            <input type="email" id="cc_payer_email" name="payer_email" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                        </div>
                        <div>
                            <label for="cc_payer_document" class="block text-sm font-medium text-gray-700">CPF (apenas números)</label>
                            <input type="text" id="cc_payer_document" name="payer_document" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                        </div>
                    </div>
                    
                    <div class="flex justify-end">
                        <button type="submit" id="pay-button" class="px-4 py-2 bg-green-500 text-white rounded hover:bg-green-600">Pagar com Cartão</button>
                    </div>
                </form>
                
                <div id="card-result" class="mt-6 hidden">
                    <div class="text-center">
                        <div id="card-success" class="hidden">
                            <div class="bg-green-100 text-green-700 p-4 rounded mb-4">
                                <p class="font-semibold">Pagamento realizado com sucesso!</p>
                                <p>O pagamento foi aprovado e sua inscrição está confirmada.</p>
                            </div>
                        </div>
                        <div id="card-pending" class="hidden">
                            <div class="bg-yellow-100 text-yellow-700 p-4 rounded mb-4">
                                <p class="font-semibold">Pagamento em processamento</p>
                                <p>O pagamento está sendo processado. Você receberá uma confirmação em breve.</p>
                            </div>
                        </div>
                        <div id="card-error" class="hidden">
                            <div class="bg-red-100 text-red-700 p-4 rounded mb-4">
                                <p class="font-semibold">Erro no pagamento</p>
                                <p id="card-error-message">Ocorreu um erro ao processar o pagamento. Por favor, tente novamente.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://sdk.mercadopago.com/js/v2"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Inicializar o SDK do Mercado Pago
        const mp = new MercadoPago('{{ $publicKey }}');
        
        // Inicializar campos do cartão
        const cardForm = mp.cardForm({
            amount: "{{ $inscription->modality->price }}",
            autoMount: true,
            form: {
                id: "form-credit-card",
                cardholderName: {
                    id: "card-holder",
                    placeholder: "Nome como está no cartão",
                },
                cardNumber: {
                    id: "card-number",
                    placeholder: "Número do cartão",
                },
                cardExpirationDate: {
                    id: "card-expiry",
                    placeholder: "MM/YY",
                },
                securityCode: {
                    id: "card-cvc",
                    placeholder: "CVV",
                },
                installments: {
                    id: "installments",
                    placeholder: "Parcelas",
                },
                identificationType: {
                    id: "docType",
                    placeholder: "Tipo de documento",
                },
                identificationNumber: {
                    id: "docNumber",
                    placeholder: "Número do documento",
                },
                issuer: {
                    id: "issuer",
                    placeholder: "Banco emissor",
                },
            },
            callbacks: {
                onFormMounted: error => {
                    if (error) console.log("Form Mounted error: ", error);
                },
                onFormUnmounted: error => {
                    if (error) console.log("Form Unmounted error: ", error);
                },
                onIdentificationTypesReceived: (error, identificationTypes) => {
                    if (error) console.log("identificationTypes handling error: ", error);
                },
                onPaymentMethodsReceived: (error, paymentMethods) => {
                    if (error) console.log("paymentMethods handling error: ", error);
                },
                onIssuersReceived: (error, issuers) => {
                    if (error) console.log("issuers handling error: ", error);
                },
                onInstallmentsReceived: (error, installments) => {
                    if (error) console.log("installments handling error: ", error);
                },
                onCardTokenReceived: (error, token) => {
                    if (error) console.log("Token handling error: ", error);
                },
                onSubmit: event => {
                    event.preventDefault();
                    
                    const cardData = cardForm.getCardFormData();
                    
                    // Processar pagamento com cartão
                    fetch('{{ route("payment.credit-card", $inscription) }}', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                        },
                        body: JSON.stringify({
                            token: cardData.token,
                            installments: cardData.installments,
                            card_type: cardData.paymentMethodId,
                            payer_email: document.getElementById('cc_payer_email').value,
                            payer_document: document.getElementById('cc_payer_document').value,
                        })
                    })
                    .then(response => response.json())
                    .then(result => {
                        document.getElementById('card-result').classList.remove('hidden');
                        
                        if (result.success) {
                            if (result.payment.status === 'approved') {
                                document.getElementById('card-success').classList.remove('hidden');
                            } else {
                                document.getElementById('card-pending').classList.remove('hidden');
                            }
                        } else {
                            document.getElementById('card-error').classList.remove('hidden');
                            document.getElementById('card-error-message').textContent = result.message;
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        document.getElementById('card-result').classList.remove('hidden');
                        document.getElementById('card-error').classList.remove('hidden');
                    });
                }
            }
        });
        
        // Alternar entre as abas de pagamento
        document.getElementById('pix-tab').addEventListener('click', function() {
            document.getElementById('pix-tab').classList.add('bg-blue-500', 'text-white');
            document.getElementById('pix-tab').classList.remove('bg-gray-300', 'text-gray-700');
            document.getElementById('credit-card-tab').classList.add('bg-gray-300', 'text-gray-700');
            document.getElementById('credit-card-tab').classList.remove('bg-blue-500', 'text-white');
            
            document.getElementById('pix-form').classList.remove('hidden');
            document.getElementById('credit-card-form').classList.add('hidden');
        });
        
        document.getElementById('credit-card-tab').addEventListener('click', function() {
            document.getElementById('credit-card-tab').classList.add('bg-blue-500', 'text-white');
            document.getElementById('credit-card-tab').classList.remove('bg-gray-300', 'text-gray-700');
            document.getElementById('pix-tab').classList.add('bg-gray-300', 'text-gray-700');
            document.getElementById('pix-tab').classList.remove('bg-blue-500', 'text-white');
            
            document.getElementById('credit-card-form').classList.remove('hidden');
            document.getElementById('pix-form').classList.add('hidden');
        });
        
        // Processar pagamento PIX
        document.getElementById('form-pix').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            
            fetch('{{ route("payment.pix", $inscription) }}', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: formData
            })
            .then(response => response.json())
            .then(result => {
                if (result.success) {
                    document.getElementById('pix-result').classList.remove('hidden');
                    document.getElementById('pix-qrcode').src = 'data:image/png;base64,' + result.pix_data.qr_code_base64;
                    document.getElementById('pix-code').value = result.pix_data.qr_code;
                } else {
                    alert('Erro ao gerar PIX: ' + result.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Erro ao processar pagamento. Por favor, tente novamente.');
            });
        });
        
        // Copiar código PIX
        document.getElementById('copy-pix').addEventListener('click', function() {
            const pixCode = document.getElementById('pix-code');
            pixCode.select();
            document.execCommand('copy');
            this.textContent = 'Copiado!';
            setTimeout(() => {
                this.textContent = 'Copiar';
            }, 2000);
        });
    });
</script>
@endpush