<div>
    <header class="header">
        <div class="header-top">
            <div class="event-brand">
                <img src="{{ asset('images/black-logo.png') }}" alt="Logo" class="brand-logo">
                <h1 class="event-title">{{ $modalityName['event_name'] ?? '' }}</h1>
            </div>
            @if (!empty($dataRounds['active_rounds']))
                <div class="rounds-info">
                    <div class="round-number">{{ $currentRoundValue ?? '' }}ª  de {{ $finalRound }}</div>
                    <div class="rounds-label">VOLTAS</div>
                </div>
            @endif
        </div>
        @if (!empty($dataRounds['active_rounds']))
            <div class="event-info">
                {{ $modalityName['name'] ?? '' }} | R$ {{ $modalityName['value'] ?? '' }} | {{ $modalityName['rule_participant'] ?? '' }} | {{ $modalityName['rule_life'] ?? '' }} Vidas
            </div>
        @endif
    </header>

    <!-- Main Content -->

    <div class="main-content" wire:poll.1000ms="refreshRounds">
        <!-- Participants List -->
        @if (!empty($dataRounds['active_rounds']))
            <div class="participants-section">
                <div id="participantsList" class="participants-list" data-round="{{ $currentRoundValue }}" data-last-signature="{{ $lastTriggerSignature ?? '' }}">
                    @php
                        $participants = $dataRounds['active_rounds'][$currentRoundValue]['participants'] ?? [];
                        $ids = array_keys($participants);
                        $values = array_values($participants);
                        $total = count($values);
                        $take = min(5, $total);
                    @endphp
                    @for ($i = 0; $i < $take; $i++)
                        @php
                            $idx = ($viewportStartIndex + $i) % max(1, $total);
                            $item = $values[$idx] ?? null;
                            $pid = $ids[$idx] ?? null;
                            $rankingClass = 'default';
                            if ($item && array_key_exists('value', $item) && !is_null($item['value'])) {
                                $rankingClass = $item['value'] == 1 ? '1' : '2';
                            }
                            $rawVal = ($item && array_key_exists('value', $item)) ? $item['value'] : null;
                        @endphp
                        @if ($item)
                            <div
                                class="participant-item position-{{ $rankingClass }}"
                                data-id="{{ $pid }}"
                                data-value="{{ is_null($rawVal) ? 'null' : $rawVal }}"
                                wire:key="p-{{ $pid }}-{{ $viewportStartIndex }}-r{{ $currentRoundValue }}"
                            >
                                {{ $item['inscription'] }}° {{ $item['name'] }}
                            </div>
                        @endif
                    @endfor
                </div>
            </div>
        @else
            <div class="participants-table">
                <div class="table-header">
                    <div class="col-position">COLOCAÇÃO</div>
                    <div class="col-name">NOME</div>
                    <div class="col-registration">INSCRIÇÃO</div>
                    <div class="col-ropes">LAÇADAS</div>
                    <div class="col-strength">FORÇA</div>
                </div>
                <div id="tableBody" class="table-body">
                    @foreach ($dataRounds['finalized_participants'] as $item)

                        @if ($item['total'] > 3)
                            @php
                                $class = 2;
                            @endphp
                        @elseif ($item['total'] < 3)
                            @php
                                $class = 3;
                            @endphp
                        @else
                            @php
                                $class = 1;
                            @endphp
                        @endif
                        <div class="table-row position-{{ $class }}">
                            <div class="row-position">{{ $item['colocation'] ?? '' }}°</div>
                            <div class="row-name">{{ $item['name'] ?? '' }}</div>
                            <div class="row-registration">{{ $item['inscription'] ?? '' }}</div>
                            <div class="row-ropes">{{ $item['total'] ?? '' }}</div>
                            <div class="row-strength">{{ $item['strength'] ?? '' }}</div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif

        @if ($dataHud)
            <div class="sponsor-section" wire:ignore>
                <div class="sponsor-slider">
                    @foreach ($dataHud as $key => $item)
                        <div class="sponsor-slide {{ $loop->first ? 'active' : '' }}" data-slide="{{ $key }}">
                            <div class="sponsor-content">
                                <img src="{{ asset("storage/{$item}") }}" alt="" class="full-image">
                            </div>
                        </div>
                    @endforeach
                </div>

                <div class="slide-indicators">
                    @foreach ($dataHud as $key => $item)
                        <span class="indicator {{ $loop->first ? 'active' : '' }}" data-slide="{{ $key }}"></span>
                    @endforeach
                </div>
            </div>
        @endif
    </div>
</div>
