@php
    $isContained = $isContained();
    $statePath = $getStatePath();
@endphp


<div wire:ignore.self x-cloak x-data="{
    step: null,

    nextStep: function() {
        let nextStepIndex = this.getStepIndex(this.step) + 1

        if (nextStepIndex >= this.getSteps().length) {
            return
        }

        this.step = this.getSteps()[nextStepIndex]

        this.autofocusFields()
        this.scrollToTop()
    },

    previousStep: function() {
        let previousStepIndex = this.getStepIndex(this.step) - 1

        if (previousStepIndex < 0) {
            return
        }

        this.step = this.getSteps()[previousStepIndex]

        this.autofocusFields()
        this.scrollToTop()
    },

    scrollToTop: function() {
        this.$nextTick(() => {
            const offset = 100
            const elementPosition = this.$root.getBoundingClientRect().top + window.scrollY - offset
            window.scrollTo({
                top: elementPosition,
                behavior: 'smooth'
            })
        })
    },

    autofocusFields: function() {
        $nextTick(() =>
            this.$refs[`step-${this.step}`]
            .querySelector('[autofocus]')
            ?.focus(),
        )
    },

    getStepIndex: function(step) {
        let index = this.getSteps().findIndex(
            (indexedStep) => indexedStep === step,
        )

        if (index === -1) {
            return 0
        }

        return index
    },

    getSteps: function() {
        return JSON.parse(this.$refs.stepsData.value)
    },

    isFirstStep: function() {
        return this.getStepIndex(this.step) <= 0
    },

    isLastStep: function() {
        return this.getStepIndex(this.step) + 1 >= this.getSteps().length
    },

    isStepAccessible: function(stepId) {
        return (
            @js($isSkippable()) || this.getStepIndex(this.step) > this.getStepIndex(stepId)
        )
    },

    updateQueryString: function() {
        if (!@js($isStepPersistedInQueryString())) {
            return
        }

        const url = new URL(window.location.href)
        url.searchParams.set(@js($getStepQueryStringKey()), this.step)

        history.pushState(null, document.title, url.toString())
    },
}"
    x-on:reset-wizard.window="step = getSteps()[0]; scrollToTop(); autofocusFields()"
    x-on:set-wizard.window="({ detail }) => {
        step = getSteps().at(detail.step);
        scrollToTop();
        autofocusFields();
    }"
    x-init="$watch('step', () => updateQueryString())

    step = getSteps().at({{ $getStartStep() - 1 }})

    autofocusFields()"
    x-on:next-wizard-step.window="if ($event.detail.statePath === '{{ $statePath }}') nextStep()"
    {{ $attributes->merge(
            [
                'id' => $getId(),
            ],
            escape: false,
        )->merge($getExtraAttributes(), escape: false)->merge($getExtraAlpineAttributes(), escape: false)->class([
            'fi-fo-wizard',
            'fi-contained rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10' => $isContained,
        ]) }}>
    <input type="hidden"
        value="{{ collect($getChildComponentContainer()->getComponents())->filter(static fn(\Filament\Forms\Components\Wizard\Step $step): bool => $step->isVisible())->map(static fn(\Filament\Forms\Components\Wizard\Step $step) => $step->getId())->values()->toJson() }}"
        x-ref="stepsData" />

    <ol @if (filled($label = $getLabel())) aria-label="{{ $label }}" @endif role="list"
        @class([
            'fi-fo-wizard-header grid divide-y divide-gray-200 dark:divide-white/5 md:grid-flow-col md:divide-y-0 md:overflow-x-auto',
            'border-b border-gray-200 dark:border-white/10' => $isContained,
            'rounded-xl bg-white shadow-sm ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10' => !$isContained,
        ])>
        @foreach ($getChildComponentContainer()->getComponents() as $step)
            <li class="mx-auto fi-fo-wizard-header-step relative flex"
                x-bind:class="{
                    'fi-active': getStepIndex(step) === {{ $loop->index }},
                    'fi-completed': getStepIndex(step) > {{ $loop->index }},
                    'hidden': getStepIndex(step) !== {{ $loop->index }}
                }">
                <button type="button" x-bind:aria-current="getStepIndex(step) === {{ $loop->index }} ? 'step' : null"
                    x-on:click="step = @js($step->getId())"
                    x-bind:disabled="!isStepAccessible(@js($step->getId()))" role="step"
                    class="fi-fo-wizard-header-step-button flex h-full items-center gap-x-4 px-6 py-4 text-start">
                    <div class="fi-fo-wizard-header-step-icon-ctn flex h-10 w-10 shrink-0 items-center justify-center rounded-full"
                        x-bind:class="{
                            'bg-primary-600 dark:bg-primary-500': getStepIndex(step) > {{ $loop->index }},
                            'border-2': getStepIndex(step) <= {{ $loop->index }},
                            'border-primary-600 dark:border-primary-500': getStepIndex(step) === {{ $loop->index }},
                            'border-gray-300 dark:border-gray-600': getStepIndex(step) < {{ $loop->index }},
                        }">
                        @php
                            $completedIcon = $step->getCompletedIcon();
                        @endphp

                        <x-filament::icon :alias="filled($completedIcon) ? null : 'forms::components.wizard.completed-step'" :icon="$completedIcon ?? 'heroicon-o-check'" x-cloak="x-cloak"
                            x-show="getStepIndex(step) > {{ $loop->index }}"
                            class="fi-fo-wizard-header-step-icon h-6 w-6 text-white" />

                        @if (filled($icon = $step->getIcon()))
                            <x-filament::icon :icon="$icon" x-cloak="x-cloak"
                                x-show="getStepIndex(step) <= {{ $loop->index }}"
                                class="fi-fo-wizard-header-step-icon h-6 w-6"
                                x-bind:class="{
                                    'text-gray-500 dark:text-gray-400': getStepIndex(step) !== {{ $loop->index }},
                                    'text-primary-600 dark:text-primary-500': getStepIndex(step) ===
                                        {{ $loop->index }},
                                }" />
                        @else
                            <span x-show="getStepIndex(step) <= {{ $loop->index }}"
                                class="fi-fo-wizard-header-step-indicator text-sm font-medium"
                                x-bind:class="{
                                    'text-gray-500 dark:text-gray-400': getStepIndex(step) !== {{ $loop->index }},
                                    'text-primary-600 dark:text-primary-500': getStepIndex(step) ===
                                        {{ $loop->index }},
                                }">
                                {{ str_pad($loop->index + 1, 2, '0', STR_PAD_LEFT) }}
                            </span>
                        @endif
                    </div>

                    <div class="grid justify-items-start md:w-max md:max-w-60">
                        @if (!$step->isLabelHidden())
                            <span class="fi-fo-wizard-header-step-label text-sm font-medium"
                                x-bind:class="{
                                    'text-gray-500 dark:text-gray-400': getStepIndex(step) < {{ $loop->index }},
                                    'text-primary-600 dark:text-primary-400': getStepIndex(step) ===
                                        {{ $loop->index }},
                                    'text-gray-950 dark:text-white': getStepIndex(step) > {{ $loop->index }},
                                }">
                                {{ $step->getLabel() }} de {{ $loop->count }}
                            </span>
                        @endif

                        @if (filled($description = $step->getDescription()))
                            <span
                                class="fi-fo-wizard-header-step-description text-start text-sm text-gray-500 dark:text-gray-400">
                                {{ $description }} de {{ $loop->count }}
                            </span>
                        @endif

                    </div>

                </button>
            </li>
        @endforeach
    </ol>

    <div @class([
        'flex items-center justify-between gap-x-3',
        'p-6' => $isContained,
        'mt-6' => !$isContained,
    ])>
        <span x-cloak
            x-on:click="
                previousStep
                $wire.previousStep(getStepIndex(step))
            "
            x-show="! isFirstStep()">
            {{ $getAction('previous') }}
        </span>

        <span x-show="isFirstStep()">
            {{ $getCancelAction() }}
        </span>



        <div>
            <button x-show="! isLastStep() && window.location.pathname !== '/admin/narrator'"
                class="text-white !bg-gray-700 p-2 rounded-lg text-sm" wire:click="initializeHud"
                wire:key="updateButton">
                <x-filament::icon wire:loading wire:target="initializeHud" icon="heroicon-o-arrow-path"
                    class="fi-fo-wizard-header-step-icon h-4 w-4 text-white animate-spin" />
                Atualizar HUD
            </button>
            <button x-show="! isLastStep() && window.location.pathname !== '/admin/narrator'"
                class="text-white !bg-gray-700 p-2 rounded-lg text-sm" wire:click="openModalAddRound"
                wire:key="updateButton">
                <x-filament::icon wire:loading wire:target="openModalAddRound" icon="heroicon-o-arrow-path"
                    class="fi-fo-wizard-header-step-icon h-4 w-4 text-white animate-spin" />
                Adicionar Voltas
            </button>
            <span x-cloak
                x-on:click="
                    $wire.dispatchFormEvent(
                        'wizard::nextStep',
                        '{{ $statePath }}',
                        getStepIndex(step),
                    )
                    $wire.nextStep(getStepIndex(step))
                "
                x-show="! isLastStep()">
                {{ $getAction('next') }}
            </span>

            <span x-show="isLastStep()">
                {{ $getSubmitAction() }}
            </span>
        </div>
    </div>

    @foreach ($getChildComponentContainer()->getComponents() as $step)
        {{ $step }}
    @endforeach

    <div @class([
        'flex items-center justify-between gap-x-3',
        'px-6 pb-6' => $isContained,
        'mt-6' => !$isContained,
    ])>
        <span x-cloak
            x-on:click="
                previousStep
                $wire.previousStep(getStepIndex(step))
            "
            x-show="! isFirstStep()">
            {{ $getAction('previous') }}
        </span>

        <span x-show="isFirstStep()">
            {{ $getCancelAction() }}
        </span>

        <div>
            <button x-show="! isLastStep() && window.location.pathname !== '/admin/narrator'"
                class="text-white !bg-gray-700 p-2 rounded-lg text-sm " wire:click="openModalFinalize"
                wire:key="updateButton">
                <x-filament::icon wire:loading wire:target="openModalFinalize" icon="heroicon-o-arrow-path"
                    class="fi-fo-wizard-header-step-icon h-4 w-4 text-white animate-spin" />
                Finalizar prova
            </button>


            <span x-cloak
                x-on:click="
                    $wire.dispatchFormEvent(
                        'wizard::nextStep',
                        '{{ $statePath }}',
                        getStepIndex(step),
                    )
                    $wire.nextStep(getStepIndex(step))
                "
                x-show="! isLastStep()">
                {{ $getAction('next') }}
            </span>
            <span x-show="isLastStep()">
                {{ $getSubmitAction() }}
            </span>
        </div>
    </div>
</div>
