@php
    $gridDirection = $getGridDirection() ?? 'column';
    $id = $getId();
    $isDisabled = $isDisabled();
    $isInline = $isInline();
    $isMultiple = $isMultiple();
    $statePath = $getStatePath();
    $label = $getLabel();
    $previousRound = \App\Models\Round::where([
        'inscription_id' => $filterRoundPrevious['inscription'],
        'participant_id' => $filterRoundPrevious['participant'],
        'event_id' => $filterRoundPrevious['event'],
        'modality_id' => $filterRoundPrevious['modality'],
        'number' => $indexRound,
        'group' => $filterRoundPrevious['group'],
    ])->first();
    $roundCurrent = \App\Models\Round::where([
        'inscription_id' => $filterRoundPrevious['inscription'],
        'participant_id' => $filterRoundPrevious['participant'],
        'event_id' => $filterRoundPrevious['event'],
        'modality_id' => $filterRoundPrevious['modality'],
        'number' => $indexRound + 1,
        'group' => $filterRoundPrevious['group'],
    ])->first();
@endphp

<div class="@if($firstLabel !== 0) -mt-6 @endif min-w-fit flex justify-center">
    <table class="w-fit border-collapse">
        @if($firstLabel != 0)
            <thead>
                <tr>
                    <th class="border border-1 border-gray-210 dark:border-white/10 p-4 text-center font-medium text-wrap break-words">Inscrição</th>
                    <th class="border border-1 border-gray-210 dark:border-white/10 p-4 text-center font-medium text-wrap break-words">Participantes</th>
                    @if($indexRound != 0)
                        <th class="border border-1 border-gray-210 dark:border-white/10 p-4 text-center font-medium text-wrap break-words">Volta {{ $indexRound }}</th>
                    @endif
                    <th class="border border-1 border-gray-210 dark:border-white/10 p-4 text-center font-medium text-wrap break-words">Volta {{ $indexRound + 1}}</th>
                </tr>
            </thead>
        @endif
        <tbody>
        <tr>
            <td
                class="border border-1 border-gray-210 dark:border-white/10 p-4 text-center font-medium text-wrap break-words"
                style="width: 11rem; max-width: 11rem;"
            >
                #{{ $filterRoundPrevious['number'] }}
            </td>
            <td
                class="border border-1 border-gray-210 dark:border-white/10 p-4 text-center font-medium text-wrap break-words"
                style="width: 11rem; max-width: 11rem;"
            >
                {{ explode('|', $getLabel())[1] }}
                @if(explode('|', $getLabel())[0])
                    <br>
                    <span class="text-gray-500">Grupo: {{ explode('|', $getLabel())[0]}}</span>
                @endif
            </td>
            @if($indexRound != 0)
                <td
                    class="border border-1 border-gray-210 dark:border-white/10 p-4 text-center font-medium text-wrap break-words"
                    style="width: 11rem; max-width: 11rem;"
                >
                    @if(!$previousRound || ($previousRound && is_null($previousRound->value)))
                        -
                    @elseif ($previousRound && $previousRound->value == 1)
                        <span style="color: #4caf50; display: inline-block;">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="4" stroke="currentColor" width="24" height="24" class="size-6">
                                <path stroke-linecap="round" stroke-linejoin="round" d="m4.5 12.75 6 6 9-13.5" />
                            </svg>
                        </span>
                    @else
                        <span style="color: red; display: inline-block;">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="4" stroke="currentColor" width="24" height="24" lass="size-6">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18 18 6M6 6l12 12" />
                            </svg>
                        </span>
                    @endif
                </td>
            @endif
            <td class="border border-1 border-gray-210 dark:border-white/10 p-4 w-fit">
                <div class="flex justify-center items-center gap-3">
                    @foreach ($getOptions() as $value => $label)
                        @php
                            $inputId = "{$id}-{$value}";
                            $shouldOptionBeDisabled = $isDisabled || $isOptionDisabled($value, $label);
                        @endphp

                        <div
                            @class([
                                'break-inside-avoid' => (! $isInline) && ($gridDirection === 'column'),
                            ])
                        >
                            <input type="radio" id="{{ $inputId }}"
                                   @if(($roundCurrent?->value === $value)) checked @endif class="hidden" disabled
                            >
                            <x-filament::button
                                :color="$getColor($value)"
                                :icon="$getIcon($value)"
                                :for="$inputId"
                                tag="label"
                            >
                                {{ $label }}
                            </x-filament::button>
                        </div>
                    @endforeach
                </div>
            </td>
        </tr>
        </tbody>
    </table>
</div>
