<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermissionsTableSeeder extends Seeder
{
    public function run()
    {
        // Event Permissions
        Permission::create(['name' => 'view_any_event']);
        Permission::create(['name' => 'view_event']);
        Permission::create(['name' => 'create_event']);
        Permission::create(['name' => 'update_event']);
        Permission::create(['name' => 'delete_event']);
        Permission::create(['name' => 'delete_any_event']);
        Permission::create(['name' => 'force_delete_event']);
        Permission::create(['name' => 'force_delete_any_event']);
        Permission::create(['name' => 'restore_event']);
        Permission::create(['name' => 'restore_any_event']);
        Permission::create(['name' => 'replicate_event']);
        Permission::create(['name' => 'reorder_event']);

        // Modality Permissions
        Permission::create(['name' => 'view_any_modality']);
        Permission::create(['name' => 'view_modality']);
        Permission::create(['name' => 'create_modality']);
        Permission::create(['name' => 'update_modality']);
        Permission::create(['name' => 'delete_modality']);
        Permission::create(['name' => 'delete_any_modality']);
        Permission::create(['name' => 'force_delete_modality']);
        Permission::create(['name' => 'force_delete_any_modality']);
        Permission::create(['name' => 'restore_modality']);
        Permission::create(['name' => 'restore_any_modality']);
        Permission::create(['name' => 'replicate_modality']);
        Permission::create(['name' => 'reorder_modality']);

        // Participant Permissions
        Permission::create(['name' => 'view_any_participant']);
        Permission::create(['name' => 'view_participant']);
        Permission::create(['name' => 'create_participant']);
        Permission::create(['name' => 'update_participant']);
        Permission::create(['name' => 'delete_participant']);
        Permission::create(['name' => 'delete_any_participant']);
        Permission::create(['name' => 'force_delete_participant']);
        Permission::create(['name' => 'force_delete_any_participant']);
        Permission::create(['name' => 'restore_participant']);
        Permission::create(['name' => 'restore_any_participant']);
        Permission::create(['name' => 'replicate_participant']);
        Permission::create(['name' => 'reorder_participant']);

        // Role Permissions
        Permission::create(['name' => 'view_any_role']);
        Permission::create(['name' => 'view_role']);
        Permission::create(['name' => 'create_role']);
        Permission::create(['name' => 'update_role']);
        Permission::create(['name' => 'delete_role']);
        Permission::create(['name' => 'delete_any_role']);

        // User Permissions
        Permission::create(['name' => 'view_any_user']);
        Permission::create(['name' => 'view_user']);
        Permission::create(['name' => 'create_user']);
        Permission::create(['name' => 'update_user']);
        Permission::create(['name' => 'delete_user']);
        Permission::create(['name' => 'delete_any_user']);
        Permission::create(['name' => 'force_delete_user']);
        Permission::create(['name' => 'force_delete_any_user']);
        Permission::create(['name' => 'restore_user']);
        Permission::create(['name' => 'restore_any_user']);
        Permission::create(['name' => 'replicate_user']);
        Permission::create(['name' => 'reorder_user']);

        $role = \Spatie\Permission\Models\Role::where('name', 'super-admin')->first();
        if ($role) {
            $role->syncPermissions(Permission::all());
        }
    }
}
