<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('round_buffers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('event_id');
            $table->unsignedBigInteger('modality_id');
            $table->string('group')->nullable();
            $table->unsignedInteger('number');
            $table->json('payload')->nullable();
            $table->timestamps();

            $table->unique(['event_id','modality_id','group','number'], 'round_buffers_unique_key');
            $table->index(['event_id','modality_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('round_buffers');
    }
};