<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('rounds', function (Blueprint $table) {
            $table->index(['modality_id', 'number'], 'rounds_modality_number_idx');
            $table->index(['inscription_id', 'participant_id', 'modality_id'], 'rounds_inscription_participant_modality_idx');
        });

        Schema::table('payments', function (Blueprint $table) {
            $table->index('payment_id', 'payments_payment_id_idx');
            $table->index(['user_id', 'status'], 'payments_user_status_idx');
        });
    }

    public function down(): void
    {
        Schema::table('rounds', function (Blueprint $table) {
            $table->dropIndex('rounds_modality_number_idx');
            $table->dropIndex('rounds_inscription_participant_modality_idx');
        });

        Schema::table('payments', function (Blueprint $table) {
            $table->dropIndex('payments_payment_id_idx');
            $table->dropIndex('payments_user_status_idx');
        });
    }
};