<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('inscription_id')->nullable()->constrained()->onDelete('set null');
            $table->string('payment_id')->nullable()->comment('ID do pagamento no Mercado Pago');
            $table->string('status')->default('pending');
            $table->string('payment_method')->comment('pix, credit_card, debit_card');
            $table->decimal('amount', 10, 2);
            $table->string('currency')->default('BRL');
            $table->json('payment_data')->nullable();
            $table->timestamp('paid_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
