<?php

use App\Models\Event;
use App\Models\Inscription;
use App\Models\Modality;
use App\Models\Round;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('round_forces', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(Inscription::class);
            $table->foreignIdFor(Modality::class);
            $table->foreignIdFor(Event::class);
            $table->string('force');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('round_forces');
    }
};
