<?php

use App\Models\Event;
use App\Models\Inscription;
use App\Models\Modality;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('participant_scores', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(Event::class);
            $table->foreignIdFor(Modality::class);
            $table->foreignIdFor(Inscription::class);
            $table->integer('total_hits')->default(0);
            $table->string('group', 20)->default('main')->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('participant_scores');
    }
};
