<?php

use App\Models\Modality;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rules', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(Modality::class)->constrained()->onDelete('cascade');
            $table->char('rule_name', 100);
            $table->bigInteger('rule_life');
            $table->boolean('rule_double_participant')->default(false);
            $table->bigInteger('rule_limit_participant');
            $table->decimal('rule_value_inscription', 8, 2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rules');
    }
};
