<?php


use App\Models\Event;
use App\Models\Modality;
use App\Models\Inscription;
use App\Models\Participant;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rounds', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(Event::class)->constrained()->cascadeOnDelete();
            $table->foreignIdFor(Inscription::class)->constrained()->cascadeOnDelete();
            $table->foreignIdFor(Modality::class)->constrained()->cascadeOnDelete();
            $table->foreignIdFor(Participant::class)->constrained()->cascadeOnDelete();
            $table->string('group', 20)->default('main')->index();
            $table->boolean('value')->nullable();
            $table->string('round_status', 20)->nullable();
            $table->integer('number')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rounds');
    }
};
