<?php

namespace App\Providers;

use Illuminate\Support\Facades\Vite;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $loader = \Illuminate\Foundation\AliasLoader::getInstance();
        $loader->alias('Debugbar', \Barryvdh\Debugbar\Facades\Debugbar::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        $this->configureModel();

        $this->configureVite();
    }

    private function configureModel(): void
    {
        Model::automaticallyEagerLoadRelationships();

        Model::unguard();

        Model::shouldBeStrict(! $this->app->isProduction());

    }

    private function configureVite(): void
    {
        Vite::useAggressivePrefetching();
    }
}
