<?php

namespace App\Observers;

use App\Models\Round;
use App\Models\RoundForce;

class RoundObserver
{
    /**
     * Handle the Round "created" event.
     */
    public function created(Round $round): void
    {
        if ($round->group === 'classification') {

            $ruleGroup = collect($round->modality->additional_rules)
                ->sortByDesc('additional_rule_life');

            $quantitySuccessRound = Round::where('value', 1)
                ->where('modality_id', $round->modality_id)
                ->where('group', 'classification')
                ->where('inscription_id', $round->inscription_id)
                ->count();

            $force = 'N/C';

            foreach ($ruleGroup as $rule) {
                $forceFind = match ($rule['conditional_participant_rule']) {
                    '>=' => ($quantitySuccessRound >= $rule['additional_rule_life']),
                    '<=' => ($quantitySuccessRound <= $rule['additional_rule_life']),
                    '>' => ($quantitySuccessRound > $rule['additional_rule_life']),
                    '<' => ($quantitySuccessRound < $rule['additional_rule_life']),
                    '=', '==' => ($quantitySuccessRound == $rule['additional_rule_life']),
                    default => throw new \InvalidArgumentException("Operador condicional inválido: {$rule['conditional_participant_rule']}"),
                };

                if ($forceFind) {
                    $force = $rule['strength_participant_rule'];
                    break;
                }
            }

            $force = is_null($force) ? 'N/C' : $force;

            RoundForce::updateOrCreate(
                [
                    'inscription_id' => $round->inscription_id,
                    'event_id' => $round->event_id,
                    'modality_id' => $round->modality_id,
                ],
                [
                    'force' => $force,
                ]
            );
        }
    }

    /**
     * Handle the Round "updated" event.
     */
    public function updated(Round $round): void
    {
        if ($round->group === 'classification') {
            $ruleGroup = collect($round->modality->additional_rules)
                ->sortByDesc('additional_rule_life');

            $quantitySuccessRound = Round::where('value', 1)
                ->where('modality_id', $round->modality_id)
                ->where('group', 'classification')
                ->where('inscription_id', $round->inscription_id)
                ->count();

            $force = null;

            foreach ($ruleGroup as $rule) {
                $forceFind = match ($rule['conditional_participant_rule']) {
                    '>=' => ($quantitySuccessRound >= $rule['additional_rule_life']),
                    '<=' => ($quantitySuccessRound <= $rule['additional_rule_life']),
                    '>' => ($quantitySuccessRound > $rule['additional_rule_life']),
                    '<' => ($quantitySuccessRound < $rule['additional_rule_life']),
                    '=', '==' => ($quantitySuccessRound == $rule['additional_rule_life']),
                    default => throw new \InvalidArgumentException("Operador condicional inválido: {$rule['conditional_participant_rule']}"),
                };
                if ($forceFind) {
                    $force = $rule['strength_participant_rule'];
                    break;
                }
            }

            $force = is_null($force) ? 'N/C' : $force;

            RoundForce::updateOrCreate(
                [
                    'inscription_id' => $round->inscription_id,
                    'event_id' => $round->event_id,
                    'modality_id' => $round->modality_id,
                ],
                [
                    'force' => $force,
                ]
            );
        }
    }
}
