<?php

namespace App\Observers;

use App\Models\Inscription;

class InscriptionObserver
{
    /**
     * Handle the inscriptions "created" event.
     */
    public function created(Inscription $inscription): void
    {
        // Número sequencial eficiente por modalidade, evitando carregar toda a relação
        $maxNumber = Inscription::where('modality_id', $inscription->modality_id)
            ->max('inscription_number');
        $inscription->inscription_number = is_null($maxNumber) ? 1 : ($maxNumber + 1);

        if(session('currentRound') > 1){
            $inscription->start_round = session('currentRound') + 1;
        }

        $inscription->saveQuietly();
    }

}
