<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RoundForce extends Model
{
    protected $fillable = [
        'inscription_id',
        'participant_id',
        'modality_id',
        'event_id',
        'force',
    ];

    public function inscription()
    {
        return $this->belongsTo(Inscription::class);
    }

    public function event()
    {
        return $this->belongsTo(Event::class);
    }

    public function modality()
    {
        return $this->belongsTo(Modality::class);
    }
}
