<?php

namespace App\Models;

use App\Models\Inscription;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Round extends Model
{
    use HasFactory;

    protected $fillable = [
        'inscription_id',
        'participant_id',
        'modality_id',
        'event_id',
        'value',
        'number',
        'group',
        'round_status',
        'force',
    ];

    public function inscription()
    {
        return $this->belongsTo(Inscription::class);
    }

    public function event()
    {
        return $this->belongsTo(Event::class);
    }

    public function modality()
    {
        return $this->belongsTo(Modality::class);
    }
}
