<?php

namespace App\Models;

use App\Models\Rule;
use App\Models\Inscription;
use App\Models\Participant;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Modality extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'event_id',
        'round_initial',
        'inscription_value',
        'additional_rules',
        'active_additional_rules',
        'status_modality',
    ];


    protected $casts = [
        'additional_rules' => 'array',
        'active_additional_rules' => 'boolean',
        'modality_status_current' => 'boolean',
        'status_modality' => 'boolean'

    ];


    public function events()
    {
        return $this->belongsToMany(Event::class);
    }

    public function participants()
    {
        return $this->belongsToMany(Participant::class);
    }

    public function rules()
    {
        return $this->hasOne(Rule::class);
    }

    public function inscriptions()
    {
        return $this->hasMany(Inscription::class);
    }

    public function statuses()
    {
        return $this->hasMany(ModalityStatus::class);
    }

    public function rounds()
    {
        return $this->hasMany(Round::class);
    }

    public function getIsCompletedAttribute()
    {
        return ! $this->rounds()
            ->whereNull('round_status')
            ->exists();
    }

}
