<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Inscription extends Model
{
    use HasFactory;


    protected $fillable = [
        'name',
        'modality_id',
        'event_id',
        'lifeless',
        'reborn',
        'inscription_status',
        'inscription_value',
        'round_lifeless',
        'inscription_number',
        'start_round'
    ];

    // Removido $with padrão para evitar N+1 e excesso de consultas automáticas

    public function event() : BelongsTo
    {
        return $this->belongsTo(Event::class);
    }

    public function participants(): BelongsToMany
    {
        return $this->belongsToMany(Participant::class)
            ->withTimestamps();
    }

    public function modality() : BelongsTo
    {
        return $this->belongsTo(Modality::class);
    }

    public function roundForces() : HasMany
    {
        return $this->hasMany(RoundForce::class);
    }

    public function results($modalityId)
    {
        return $this->hasMany(Round::class)
            ->where('value',1)
            ->where('modality_id',$modalityId)
            ->count();
    }

    public function rounds() : HasMany
    {
        return $this->hasMany(Round::class);
    }

    public function satisfiesRule($modalityId, $conditionalOperator, $ruleValue)
    {
        $count = $this->results($modalityId);

        switch ($conditionalOperator) {
            case '>=':
                return $count >= $ruleValue;
            case '<=':
                return $count <= $ruleValue;
            case '>':
                return $count > $ruleValue;
            case '<':
                return $count < $ruleValue;
            case '=':
            case '==':
                return $count == $ruleValue;
            default:
                throw new \InvalidArgumentException("Operador condicional inválido: {$conditionalOperator}");
        }
    }
}
