<?php

namespace App\Models;

use App\Models\Modality;
use App\Models\Inscription;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Event extends Model
{
    use HasFactory;

    protected $fillable = [
        "name",
        "info_event",
        "image_event",
    ];




    public function organizer()
    {
        return $this->hasMany(Organizer::class);
    }

    public function eventDate()
    {
        return $this->hasMany(EventDate::class);
    }

    public function hud()
    {
        return $this->hasMany(Hud::class);
    }

    public function modalities()
    {
        return $this->belongsToMany(Modality::class);
    }

    public function inscriptions()
    {
        return $this->hasMany(Inscription::class);
    }

    public function getInfoEventSummaryAttribute()
    {
        return Str::limit(strip_tags($this->info_event), 50);
    }
}
