<?php

namespace App\Filament\Widgets;

use App\Models\Modality;
use App\Models\Inscription;
use App\Models\Participant;
use EightyNine\FilamentAdvancedWidget\AdvancedStatsOverviewWidget as BaseWidget;
use EightyNine\FilamentAdvancedWidget\AdvancedStatsOverviewWidget\Stat;

class DashboardStatsOverviewWidget extends BaseWidget
{
    protected static ?string $pollingInterval = null;
    protected function getStats(): array
    {
        $participantCount = Participant::count();
        $inscriptionCount = Inscription::count();

        $totalValue = Modality::withCount(['inscriptions'])
            ->get()
            ->sum(function ($modality) {
                return $modality->inscription_value * $modality->inscriptions_count;
            });
        $totalValueFormatted = number_format($totalValue, 2, ',', '.');

        return [
            Stat::make('Quantidade', $participantCount )->icon('heroicon-o-user')
                ->iconColor('success')
                ->iconPosition('start')
                ->description('Total Participantes')
                ->descriptionIcon('heroicon-o-chevron-up', 'before')
                ->descriptionColor('success'),
            Stat::make('Quantidade', $inscriptionCount )->icon('heroicon-o-user-group')
                ->iconColor('info')
                ->iconPosition('start')
                ->description('Total Inscrições')
                ->descriptionIcon('heroicon-o-chevron-up', 'before')
                ->descriptionColor('info'),
            Stat::make('Valor', "R$ {$totalValueFormatted}")->icon('heroicon-o-currency-dollar')
                ->iconColor('primary')
                ->color('primary')
                ->description('Valor Total Inscrições')
                ->color('success')
                ->descriptionIcon('heroicon-o-arrow-up-circle')
                ->descriptionColor('primary'),


        ];
    }
}
