<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ModalityResource\Pages;
use App\Filament\Resources\ModalityResource\RelationManagers;
use App\Models\Modality;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ModalityResource extends Resource
{
    protected static bool $shouldRegisterNavigation = false;

    protected static ?string $model = Modality::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('name')
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('round_initial')
                    ->required()
                    ->numeric(),
                Forms\Components\TextInput::make('inscription_value')
                    ->required()
                    ->numeric(),
                Forms\Components\TextInput::make('additional_rules'),
                Forms\Components\Toggle::make('active_additional_rules')
                    ->required(),
                Forms\Components\Toggle::make('active_reinscription_lap')
                    ->required(),
                Forms\Components\Toggle::make('status_modality')
                    ->required(),
                Forms\Components\Toggle::make('modality_status_current')
                    ->required(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->searchable(),
                Tables\Columns\TextColumn::make('round_initial')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('inscription_value')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\IconColumn::make('active_additional_rules')
                    ->boolean(),
                Tables\Columns\IconColumn::make('active_reinscription_lap')
                    ->boolean(),
                Tables\Columns\IconColumn::make('status_modality')
                    ->boolean(),
                Tables\Columns\IconColumn::make('modality_status_current')
                    ->boolean(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListModalities::route('/'),
            'create' => Pages\CreateModality::route('/create'),
            'edit' => Pages\EditModality::route('/{record}/edit'),
        ];
    }
}
