<?php

namespace App\Filament\Resources\EventResource\RelationManagers;
use Closure;
use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Get;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Filament\Support\RawJs;
use Leandrocfe\FilamentPtbrFormFields\Money;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Resources\RelationManagers\RelationManager;

class ModalitiesRelationManager extends RelationManager
{
    protected static string $relationship = 'modalities';

    protected static ?string $title = 'Modalidades';

    protected function getDefaultSort(): ?string
    {
        return 'status_modality asc';
    }

    public static function getModelLabel(): string
    {
        return __('Modality');
    }

    public function form(Form $form): Form
    {
        return $form
        ->schema([
                Forms\Components\Grid::make()
                ->schema([
                    Forms\Components\TextInput::make('name')
                        ->required()
                        ->prefixIcon('heroicon-o-user')
                        ->columnSpan(2)
                        ->maxLength(255),
                    Money::make('inscription_value'),
                    Forms\Components\TextInput::make('round_initial')
                        ->label('Número de voltas')
                        ->required()
                        ->columnSpan(1)
                        ->prefixIcon('heroicon-o-arrow-path-rounded-square')
                        ->numeric(),
                ])->columns(2),
                Forms\Components\Grid::make()
                    ->relationship('rules')
                    ->schema([
                        Forms\Components\TextInput::make('rule_life')
                        ->required()
                        ->prefixIcon('heroicon-o-heart')
                        ->numeric()
                        ->columnSpan(1),
                    Forms\Components\Select::make('participant_rule')
                        ->label('Tipo individual ou em grupo')
                        ->prefixIcon('heroicon-o-user-group')
                        ->columnSpan(1)
                        ->options([
                            'Individual' => 'Individual',
                            'Dupla' => 'Dupla',
                            'Trio' => 'Trio',
                            'Quarteto' => 'Quarteto',
                            'Quinteto' => 'Quinteto'
                        ])
                        ->default('Individual')
                        ->required(),
                ])->columns(2),
                Forms\Components\Grid::make()
                    ->relationship('rules')
                    ->schema([
                        Forms\Components\Fieldset::make('Novas Inscrições e Zerar vidas')
                            ->schema([
                                Forms\Components\Toggle::make('active_reinscription_lap')
                                    ->label('Permitir novas inscrições?')
                                    ->reactive()
                                    ->columnSpan(1)
                                    ->inline(false),
                                Forms\Components\TextInput::make('reinscription_lap')
                                    ->required()
                                    ->label('Definir volta para o limite de inscrição')
                                    ->visible(fn (Get $get): bool => $get('active_reinscription_lap'))
                                    ->prefixIcon('heroicon-o-arrow-path-rounded-square')
                                    ->columnSpan(1)
                                    ->numeric(),
                                Forms\Components\Toggle::make('active_zero_life')
                                    ->label('Permitir zerar as vidas')
                                    ->reactive()
                                    ->columnSpan(1)
                                    ->inline(false),
                                Forms\Components\TextInput::make('zero_life_lap')
                                    ->required()
                                    ->label('Definir volta para zerar as vidas')
                                    ->visible(fn (Get $get): bool => $get('active_zero_life'))
                                    ->prefixIcon('heroicon-o-arrow-path-rounded-square')
                                    ->columnSpan(1)
                                    ->numeric(),
                            ])->columns(2),
                    ])->columns(2),

                Forms\Components\Fieldset::make('Separar por força')
                    ->schema([
                        Forms\Components\Toggle::make('active_additional_rules')
                            ->label('Habilitar separação por força?')
                            ->reactive()
                            ->columnSpanFull()
                            ->inline(false),
                        Forms\Components\Repeater::make('additional_rules')
                            ->label('Cadastro de regras adicionais')
                            ->columnSpanFull()
                            ->visible(fn (Get $get): bool => $get('active_additional_rules'))
                            ->schema([
                                Forms\Components\Select::make('conditional_participant_rule')
                                    ->label('Condição')
                                    ->prefixIcon('heroicon-o-user-group')
                                    ->options([
                                        '>' => 'Maior',
                                        '<' => 'Menor',
                                        '==' => 'Igual',
                                        '>=' => 'Maior ou igual',
                                        '<=' => 'Menor ou igual'
                                    ])
                                    ->required(),
                                Forms\Components\TextInput::make('additional_rule_life')
                                    ->label('Laçadas')
                                    ->required()
                                    ->prefixIcon('heroicon-o-heart')
                                    ->numeric(),

                                Forms\Components\Select::make('strength_participant_rule')
                                    ->label('Força')
                                    ->prefixIcon('heroicon-o-user-group')
                                    ->options([
                                        'A' => 'Força A',
                                        'B' => 'Força B',
                                        'C' => 'Força C',
                                        'D' => 'Força D',

                                    ])
                                    ->required(),
                        ])->columns(3),
                    ])
                ]);

    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('name')
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->sortable()
                    ->searchable(),
                Tables\Columns\TextColumn::make('round_initial')
                    ->label('Número de voltas')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('inscription_value')
                    ->label('Valor da inscrição')
                    ->money('brl')
                    ->sortable(),
                Tables\Columns\TextColumn::make('rules.participant_rule')
                    ->label('Individual\Grupo')
                    ->sortable(),
                Tables\Columns\IconColumn::make('status_modality')
                    ->label('Finalizada')
                    ->boolean()
                    ->trueIcon('heroicon-o-check-badge')
                    ->falseIcon('heroicon-o-x-mark')
                    ->sortable(query: function (Builder $query, string $direction) {
                        $query->orderBy('status_modality', $direction === 'asc' ? 'asc' : 'desc');
                    }),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->defaultSort('status_modality', 'asc')
            ->filters([
                //
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make(),
            ])
            ->actions([
                Tables\Actions\EditAction::make()->color('success'),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

}
