<?php

namespace App\Filament\Resources;

use App\Filament\Resources\EventResource\Pages;
use App\Filament\Resources\EventResource\RelationManagers\InscriptionsRelationManager;
use App\Filament\Resources\EventResource\RelationManagers\ModalitiesRelationManager;
use App\Models\Event;
use Filament\Forms;
use Filament\Forms\Components\Split;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class EventResource extends Resource
{
    protected static ?string $model = Event::class;

    public static function getModelLabel(): string
    {
        return __('Event');
    }

    protected static ?string $navigationIcon = 'heroicon-o-calendar';

    protected static ?string $navigationGroup = 'Cadastros';

    protected static ?string $navigationLabel = 'Eventos';

    public static function getNavigationBadge(): ?string
    {
        return Event::count();
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Split::make([
                    Forms\Components\Section::make('Cadastre as informações do evento')
                        ->schema([
                        Forms\Components\TextInput::make('name')
                            ->required()
                            ->prefixIcon('heroicon-o-document')
                            ->maxLength(255),
                        Forms\Components\FileUpload::make('image_event')
                            ->image(),
                        Forms\Components\RichEditor::make('info_event')
                            ->toolbarButtons([
                                'bold',
                                'bulletList',
                                'h2',
                                'h3',
                                'italic',
                                'link',
                                'orderedList',
                                'redo',
                                'strike',
                                'underline',
                                'undo',
                            ])
                            ->columnSpanFull(),
                        Forms\Components\Repeater::make('hud')
                            ->relationship('hud')
                            ->defaultItems(0)
                            ->schema([
                                Forms\Components\FileUpload::make('image')
                                    ->label("Imagens da HUD")
                                    ->image()
                                ]),
                        ])
                    ->grow(),
                Forms\Components\Section::make('Datas e organizadores')
                    ->schema([
                    Forms\Components\Repeater::make('Datas')
                        ->relationship('eventDate')
                        ->defaultItems(0)
                        ->schema([
                            Forms\Components\DatePicker::make('date')
                            ->required()
                        ]),
                    Forms\Components\Repeater::make('Organizadores')
                        ->relationship('organizer')
                        ->defaultItems(0)
                        ->schema([
                        Forms\Components\TextInput::make('name')
                            ->prefixIcon('heroicon-o-user')
                            ->required()
                            ->maxLength(255),
                        Forms\Components\TextInput::make('phone')
                            ->prefixIcon('heroicon-o-phone')
                            ->mask('(99) 99999-9999')
                            ->required()
                            ->maxLength(255),
                        ])
                    ])
                    ->grow(false),
                ])->from('md'),
            ])
            ->columns(1);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->searchable(),
                Tables\Columns\TextColumn::make('info_event_summary')
                    ->label('Informação do evento')
                    ->limit(50)
                    ->searchable(),
                Tables\Columns\TextColumn::make('info_event_summary')
                    ->label('Informação do evento')
                    ->limit(50)
                    ->searchable(),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make()->color('success'),
                Tables\Actions\DeleteAction::make()
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            ModalitiesRelationManager::class,
            InscriptionsRelationManager::class
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListEvents::route('/'),
            'create' => Pages\CreateEvent::route('/create'),
            'edit' => Pages\EditEvent::route('/{record}/edit'),
        ];
    }
}
