<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class HudEvent implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $modalityId;
    public $eventId;
    public $currentStep;
    public $finalStep;

    public function __construct($modalityId, $eventId, $currentStep, $finalStep)
    {
        $this->modalityId = $modalityId;
        $this->eventId = $eventId;
        $this->currentStep = $currentStep;
        $this->finalStep = $finalStep;
    }

    // Define os dados que serão enviados no broadcast
    public function broadcastWith()
    {
        return [
            'modalityId' => $this->modalityId,
            'eventId' => $this->eventId,
            'currentStep' => $this->currentStep,
            'finalStep' => $this->finalStep,
        ];
    }

    // Define o canal de broadcast
    public function broadcastOn(): array
    {
        return [
            new Channel("world-rodeo")
        ];
    }

}
