# Docker - Laco Pro

Ambiente de desenvolvimento Laravel com Docker: PHP-FPM, Nginx, MySQL, Redis e Node/Vite.

## Pré-requisitos (Windows)
- Docker Desktop com WSL2 habilitado
- Portas livres: `8080` (Nginx) e `5173` (Vite)

## Passo a passo
1) Copiar o ambiente de Docker:
```bash
# PowerShell
Copy-Item .env.docker .env
# CMD
copy .env.docker .env
```

2) Subir os serviços (builda a imagem do PHP-FPM):
```bash
docker compose up -d --build
```

3) Instalar dependências PHP (Composer):
```bash
docker compose run --rm composer install
```

4) Gerar chave da aplicação:
```bash
docker compose exec app php artisan key:generate
```

5) Linkar storage (arquivos públicos):
```bash
docker compose exec app php artisan storage:link
```

6) Migrar banco (e opcionalmente seedar):
```bash
docker compose exec app php artisan migrate
# Opcional
# docker compose exec app php artisan db:seed
```

7) Subir Vite (hot reload):
```bash
docker compose up -d npm
```

8) (Opcional/Se usar broadcast) Configurar Pusher:
- Adicione no `.env`:
```env
BROADCAST_DRIVER=pusher
PUSHER_APP_ID=seu-app-id
PUSHER_APP_KEY=seu-app-key
PUSHER_APP_SECRET=seu-app-secret
PUSHER_APP_CLUSTER=sa1
PUSHER_HOST=
PUSHER_PORT=443
PUSHER_SCHEME=https

VITE_PUSHER_APP_KEY=${PUSHER_APP_KEY}
VITE_PUSHER_APP_CLUSTER=${PUSHER_APP_CLUSTER}
VITE_PUSHER_HOST=
VITE_PUSHER_PORT=443
VITE_PUSHER_SCHEME=https
```
- Instale libs e limpe configs:
```bash
docker compose exec app composer require pusher/pusher-php-server
docker compose exec app php artisan config:clear
# Frontend
docker compose exec npm sh -c "npm install laravel-echo pusher-js"
docker compose up -d npm
```

A aplicação fica acessível em: `http://localhost:8080`

## Comandos úteis
- Logs: `docker compose logs -f nginx`
- Reiniciar serviço: `docker compose restart app`
- Artisan: `docker compose exec app php artisan <comando>`
- Composer: `docker compose exec app composer <comando>`
- Parar/remover: `docker compose down`

## Banco de dados
- Host: `mysql` | Porta: `3306` | DB: `laco` | User: `laco` | Password: `secret`
- Dados persistem no volume `mysql_data`.

## Build de assets (produção)
```bash
docker compose run --rm npm run build
```

## Redis
Disponível em `redis:6379`. Ajuste `CACHE_DRIVER` no `.env` caso não use.