# 🏇 Laco Pro
Sistema para gerenciamento de provas de rodeio com contagem de rodadas, HUD em tempo real e painel administrativo.

## Tecnologias
- Backend: Laravel 12 (PHP 8.3) + MySQL
- Frontend: Tailwind + Livewire/Alpine + Vite
- Tempo real: Laravel Echo + Pusher

## Requisitos
- PHP 8.2+ com Composer
- Node 18+ (Vite)
- MySQL 8+

## Instalação (Local)
```bash
# 1) Clonar e entrar no projeto
git clone <seu-repo>
cd laco_pro

# 2) Instalar dependências PHP
composer install

# 3) Copiar .env e ajustar
cp .env.example .env
```
Edite o `.env` com seu banco de dados:
```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=laco_pro
DB_USERNAME=root
DB_PASSWORD=
```
Configure o Pusher (se for usar broadcast):
```env
BROADCAST_DRIVER=pusher
PUSHER_APP_ID=seu-app-id
PUSHER_APP_KEY=seu-app-key
PUSHER_APP_SECRET=seu-app-secret
PUSHER_APP_CLUSTER=sa1
PUSHER_HOST=
PUSHER_PORT=443
PUSHER_SCHEME=https

VITE_PUSHER_APP_KEY=${PUSHER_APP_KEY}
VITE_PUSHER_APP_CLUSTER=${PUSHER_APP_CLUSTER}
VITE_PUSHER_HOST=
VITE_PUSHER_PORT=443
VITE_PUSHER_SCHEME=https
```

```bash
# 4) Gerar chave e preparar app
php artisan key:generate
php artisan storage:link
php artisan migrate
php artisan config:cache

# 5) Frontend
npm install
npm run dev && npm run build
```
Acesse o app no navegador (ambiente local): `http://localhost:8000` (ou sua URL configurada).

## Usuário Admin (Filament)
Crie um usuário para acessar o painel:
```bash
php artisan make:filament-user
```

## Permissões (Shield)
Conceda permissões administrativas e instale o painel de permissões:
```bash
php artisan shield:super-admin
php artisan shield:install admin
```
Documentação: https://filamentphp.com/plugins/bezhansalleh-shield

## Docker (Opcional)
Prefere rodar com Docker? Siga o guia: `README_DOCKER.md`.

## Links
- Filament: https://filamentphp.com/
- Laravel: https://laravel.com/
